DELIMITER $$
DROP PROCEDURE IF EXISTS V20220908205711__Update_RejectApplicationRecipientQuery $$
CREATE PROCEDURE V20220908205711__Update_RejectApplicationRecipientQuery()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="REJECT_APPLICATION_RECIPIENTS") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="REJECT_APPLICATION_RECIPIENTS");

update sql_dtprovider set sqlQuery="select T4.id AS ID,
    	T3.`salutationName` AS SALUTATION_NAME,
    	T2.`firstName` AS FIRST_NAME,
    	T2.`middleName` AS MIDDLE_NAME,
    	T2.`lastName` AS LAST_NAME,
    	T2.`emailId` AS EMAIL_ID,
    	T2.`mobileNumber` AS MOBILE_NO,
        T1.`code` as APPLICATION_CODE,
        T5.displayName AS ACADEMY_NAME_LOCATION,
        CONCAT(T7.addressText,' ',T8.cityName,', ',T9.countryName,', ',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
        CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
        T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
        T11.programName AS PROGRAM_NAME,
        T13.batchName AS BATCH_NAME,
        T14.printName AS APPLICATION_OWNER_NAME,
        T16.emailId AS OWNER_EMAIL_ID,
    	ml.`code` AS LANGUAGE_KEY,
        CONCAT(T16.mobileCountryCode,
                ' ',
                T16.mobileNumber) AS OWNER_MOBILE_NO,
        (CASE
            WHEN
                T5.logoUrl IS NULL
                    AND org.orgUrl IS NOT NULL
            THEN
                CONCAT(org.orgUrl,
                        '/',
                        'emailer/images/logo_default_image.png')
            WHEN
                T5.logoUrl IS NULL
                    AND org.orgUrl IS NULL
            THEN
                'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
            ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
        END) AS LOGO_URL,
    T3.`salutationNameInOtherLanguage` AS TITLE_IN_OTHER_LANGUAGE,T11.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_LANGUAGE,
         ml.itemValue as CORRESPONDENCE_LANGUAGE,
   	T19.itemValue as CURRENT_ACTIVITY,
   	T18.groupName AS PROGRAM_GROUP_NAME,
     T2.printName AS APPLICANT_PRINT_NAME,
      T24.value AS REJECTION_REASON,
      T4.rejection_remark AS REJECTION_REMARKS,
      DATE_FORMAT(NOW(), '%d-%m-%Y') AS REJECTION_CURRENT_DATE
   from application T1 
    		left outer join
        applicant_person T2 on T1.applicantPersonId=T2.id
   		LEFT JOIN 
        current_activity T19 ON T19.id = T2.current_activity_id
    		inner join
    	salutations T3 on T3.id = T2.salutationId
    		LEFT JOIN
        application_program T4 ON T4.applicationId = T1.id
    		LEFT OUTER JOIN
        academy_location T5 ON T5.id = T4.academyLocationId
            LEFT OUTER JOIN
        academy_location_addresses T6 ON T6.academyLocationId = T5.id
    		LEFT OUTER JOIN
        address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
    		LEFT OUTER JOIN
    	city T8 ON T8.id = T7.cityId
    		LEFT OUTER JOIN
    	country T9 ON T9.id = T8.countryId
    		LEFT OUTER JOIN
    	country_region T10 ON T10.id = T8.countryRegionId
    		LEFT OUTER JOIN
    	programs T11 ON T11.id = T4.programId
   		LEFT JOIN
   	program_group T18 ON T18.id = T11.programGroupId 
    		LEFT JOIN
        prog_batch_seat_config T22 ON T4.progBatchSeatConfigId=T22.id
    		LEFT JOIN
        batches T13 ON T13.id=T22.programBatchId
    		LEFT JOIN
    	users T14 ON T14.id=T1.applicationOwner
    		LEFT JOIN
        staffs T15 ON T15.userId = T14.id
            LEFT JOIN
        persons T16 ON T16.id = T15.personId
    		LEFT JOIN
        multi_language ml ON ml.id = T2.correspondence_language
          LEFT JOIN
      intake_year T23 ON T23.id = T13.intakeYearId
          LEFT JOIN
      application_prog_rejection_reasons T24 ON T24.id = T4.rejection_reason_id
    		LEFT OUTER JOIN
        organizations org ON org.id = (SELECT 
                MAX(id)
            FROM
                organizations)
        where T4.id in(namedParams) group by T4.id", jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "code",
              "resultKey": "APPLICATION_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "logoUrl",
              "resultKey": "LOGO_URL",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "displayName",
              "resultKey": "ACADEMY_NAME_LOCATION",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Academy Location Phone No.",
              "resultKey": "ACADEMY_LOCATION_PHONE_NO",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Academy Location Email Id",
              "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "Program Name",
              "resultKey": "PROGRAM_NAME",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "Batch Name",
              "resultKey": "BATCH_NAME",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "Application Owner Name",
              "resultKey": "APPLICATION_OWNER_NAME",
              "displayCode": "",
              "displayOrder": 15
          },
          {
              "id": 17,
              "value": "Owner EmailId",
              "resultKey": "OWNER_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 16
          },
          {
              "id": 18,
              "value": "Owner Mobile No",
              "resultKey": "OWNER_MOBILE_NO",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "Reason for Rejection",
              "resultKey": "REJECTION_REASON",
              "displayCode": "",
              "displayOrder": 18
          },
          {
              "id": 20,
              "value": "Rejection Remarks",
              "resultKey": "REJECTION_REMARKS",
              "displayCode": "",
              "displayOrder": 19
          },{
              "id": 21,
              "value": "Salutation / Title in other Language",
              "resultKey": "TITLE_IN_OTHER_LANGUAGE",
              "displayCode": "",
              "displayOrder": 20
          },{
              "id": 22,
              "value": "Program Name in Other Language",
              "resultKey": "PROGRAM_PRINT_NAME_LANGUAGE",
              "displayCode": "",
              "displayOrder": 21
          },
  {
              "id": 21,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 20
          },
  {
              "id": 22,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 21
          },
  {
              "id": 23,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 22
          },
          {
                "id": 24,
                "value": "Intake Year",
                "resultKey": "INTAKE_YEAR",
                "displayCode": "",
                "displayOrder": 23
            },
         {
                "id": 26,
                "value": "Rejection Current Date",
                "resultKey": "REJECTION_CURRENT_DATE",
                "displayCode": "",
                "displayOrder": 25
            },
			{
                "id": 27,
                "value": "Applicant Print Name",
                "resultKey": "APPLICANT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 26
            }
      ]
  }'
   where dataProviderId=@dtProviderId;
   

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20220908205711__Update_RejectApplicationRecipientQuery () $$
DROP PROCEDURE IF EXISTS V20220908205711__Update_RejectApplicationRecipientQuery $$
DELIMITER ;